unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, jpeg, ExtCtrls, OleCtrls, SHDocVw, ComCtrls, Menus,
  StdCtrls, XPMan, ActnList, XPStyleActnCtrls, ActnMan, ToolWin, ShellAPI;

type
  TForm1 = class(TForm)
    TreeView1: TTreeView;
    Image1: TImage;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    XPManifest1: TXPManifest;
    N2: TMenuItem;
    N3: TMenuItem;
    Panel1: TPanel;
    WebBrowser1: TWebBrowser;
    ToolBar1: TToolBar;
    Label1: TLabel;
    Label2: TLabel;
    CtrlH1: TMenuItem;
    procedure N1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TreeView1CustomDrawItem(Sender: TCustomTreeView; Node: TTreeNode; State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure N2Click(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure TreeView1Click(Sender: TObject);
    procedure LoadInTree();
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure CtrlH1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  mydir,contentdir:string;

implementation

uses Unit2, Unit3;

{$R *.dfm}

procedure TForm1.N1Click(Sender: TObject);
begin
Form1.Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin

mydir:=ExtractFilePath(ParamStr(0));
mydir:=mydir+'\';
LoadInTree();

end;

procedure TForm1.LoadInTree;
var
   papki,fail:TSearchRec;
   i:integer;
   nod:TTreeNode;
begin
  i:=-1;
    if FindFirst(Mydir+'*', faDirectory, papki) = 0 then
     begin
      repeat
        if (papki.attr and faDirectory) = faDirectory then
        begin
          if (papki.name<>'.') and (papki.name<>'..')then
          begin
            TreeView1.Items.Add(nil,papki.name);
            i:=i+1;
            nod:=TreeView1.Items[i];
            if FindFirst(Mydir+papki.name+'\*._', faDirectory, fail) = 0 then
            begin
              repeat
                  if (fail.name<>'.') and (fail.name<>'..')then
                  begin
                    TreeView1.Items.AddChild(nod,fail.name);
                    i:=i+1;
                  end;
              until FindNext(fail) <> 0;

              FindClose(fail);
            end;
          end;
        end;
      until FindNext(papki) <> 0;

      FindClose(papki);
      end;
end;

procedure TForm1.TreeView1CustomDrawItem(Sender: TCustomTreeView;
  Node: TTreeNode; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
with TreeView1.Canvas do
  if cdsSelected in State then
begin
  Brush.Color:=clBtnHighLight;
  Font.Color:=clBlack;
end;
end;

procedure TForm1.N2Click(Sender: TObject);
const
  ID_FIND_ACCELERATOR = $43;
var
  IEServerHandle: DWORD;
begin
  IEServerHandle :=
  GetWindow(GetWindow(Form1.WebBrowser1.Handle, GW_CHILD), GW_CHILD);
  SendMessage(IEServerHandle, WM_COMMAND, ID_FIND_ACCELERATOR, 0);
end;

procedure TForm1.N3Click(Sender: TObject);
begin
Form3.ShowModal;
end;

procedure TForm1.TreeView1Click(Sender: TObject);
var TreeNode: TTreeNode; //    
begin

  TreeNode:=TreeView1.Selected; //     

  while TreeNode.Parent <> nil do
    TreeNode:=TreeNode.Parent; //     

    if TreeNode.Text = TreeView1.Selected.Text then
    Label2.Caption:=' '+TreeNode.Text+' ' else
    Label2.Caption:=' '+TreeNode.Text + ' / ' + TreeView1.Selected.Text;

    TreeNode:=nil;

if (TreeView1.Selected.Level<>0) then
begin
WebBrowser1.Navigate(mydir+TreeView1.Selected.Parent.Text+ '\' +TreeView1.Selected.Text);
end;

end;

procedure TForm1.TreeView1Change(Sender: TObject; Node: TTreeNode);
var sindex:integer;
begin

sindex:=TreeView1.Selected.AbsoluteIndex;

if TreeView1.Selected.Text='- ' then
begin
WebBrowser1.Navigate(GetCurrentDir+'//'+'- .htm');
end;

if TreeView1.Selected.Text='01.' then
begin
WebBrowser1.Navigate(GetCurrentDir+'//'+'01..htm');
end;

if TreeView1.Selected.Text='02.' then
begin
WebBrowser1.Navigate(GetCurrentDir+'//'+'02..htm');
end;

if TreeView1.Selected.Text='03.  ' then
begin
WebBrowser1.Navigate(GetCurrentDir+'//'+'03.  .htm');
end;

if TreeView1.Selected.Text='04. ' then
begin
WebBrowser1.Navigate(GetCurrentDir+'//'+'04. .htm');
end;

if TreeView1.Selected.Text='05. ' then
begin
WebBrowser1.Navigate(GetCurrentDir+'//'+'05. .htm');
end;

if TreeView1.Selected.Text='06.  ' then
begin
WebBrowser1.Navigate(GetCurrentDir+'//'+'06.  .htm');
end;

if TreeView1.Selected.Text='07.  ' then
begin
WebBrowser1.Navigate(GetCurrentDir+'//'+'07.  .htm');
end;

if TreeView1.Selected.Text='08.' then
begin
WebBrowser1.Navigate(GetCurrentDir+'//'+'08..htm');
end;

if TreeView1.Selected.Text='01.  ._' then
begin
ShellExecute(handle,'Open',pchar(extractfilepath(application.ExeName)+'\  \Tester.exe'),nil,nil,SW_SHOWNORMAL);
Form1.TreeView1.Items.Item[sindex-1].Selected:=True;
end;

if TreeView1.Selected.Text='09. ' then
begin
WebBrowser1.Navigate(GetCurrentDir+'//'+'09. .htm');
end;

end;

procedure TForm1.CtrlH1Click(Sender: TObject);
begin
TreeView1.FullCollapse;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
Form1.WindowState:=wsMaximized;
end;

end.
